#!/usr/bin/env python
# -*- coding: utf-8 -*-

import argparse
import pika

parser = argparse.ArgumentParser()
parser.add_argument('--host', default='localhost', action='store', dest='host', help='server host')
parser.add_argument('--port', default=5672, type=int, action='store', dest='port', help='server port')
parser.add_argument('--ssl', default=False, action='store_true', dest='ssl', help='use ssl')
parser.add_argument('--user', default='myuser', action='store', dest='user', help='username')
parser.add_argument('--password', default='mypass', action='store', dest='password', help='password')
parser.add_argument('--name', default='myq', action='store', dest='name', help='queue name')
parser.add_argument('--file', required=True, action='store', dest='file', help='import filename')
args = parser.parse_args()

parameters = pika.ConnectionParameters(host=args.host,
                                       port=args.port,
                                       virtual_host='/',
                                       credentials=pika.PlainCredentials(args.user, args.password),
                                       ssl=args.ssl)

connection = pika.BlockingConnection(parameters)
if connection.is_open:
    channel = connection.channel()
    channel.queue_declare(queue=args.name,durable=True)
    with open(args.file, 'r') as ptr:
        CNT = 1
        for line in ptr:
            body = line.strip()
            channel.basic_publish(exchange='',
                                  routing_key=args.name,
                                  body=body,
                                  properties=pika.BasicProperties(delivery_mode = pika.spec.PERSISTENT_DELIVERY_MODE))
            print(" [x] Sent to %s cnt(%s)" % (args.name, CNT))
            CNT += 1
        ptr.close()
    connection.close()
