#!/usr/bin/env python

import argparse
import pika

parser = argparse.ArgumentParser()
parser.add_argument('--host', default='localhost', action='store', dest='host', help='server host')
parser.add_argument('--port', default=5672, type=int, action='store', dest='port', help='server port')
parser.add_argument('--ssl', default=False, action='store_true', dest='ssl', help='use ssl')
parser.add_argument('--user', default='myuser', action='store', dest='user', help='username')
parser.add_argument('--password', default='mypass', action='store', dest='password', help='password')
args = parser.parse_args()

parameters = pika.ConnectionParameters(host=args.host,
                                       port=args.port,
                                       virtual_host='/',
                                       credentials=pika.PlainCredentials(args.user, args.password),
                                       ssl=args.ssl)

try:
    connection = pika.BlockingConnection(parameters)
    if connection.is_open:
        print('OK')
    connection.close()
except Exception as error:
    print('Error:', error.__class__.__name__)
